/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.PatchEvent;
import com.ibm.hwmca.base.updates.PatchEventHandler;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;

public final class PatchEventHandlerManager {
    private static final String TRACE_MASKT = "XMCLPEMT";
    private static final String TRACE_MASKF = "XMCLPEMF";
    private static final String TRACE_MASKD = "XMCLPEMD";
    private static final String TRACE_CLASS = "PatchEventHandlerManager";
    private static final String TRACE_IN = "-> ";
    private static final String TRACE_OUT = "<- ";
    private static final String TRACE_INOUT = "<> ";
    private static final String TRACE_OTHER = "   ";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "MclPatEvtMgr");
    private static PatchEventHandlerManager thePatchEventHandlerManager = null;
    private ArrayList listeners = new ArrayList();
    private Object listenersLock = new Object();

    public static synchronized PatchEventHandlerManager getPatchEventHandlerManager() {
        String TRACE_METHOD = ".getPatchEventHandlerManager()";
        Trace.trace(TRACE_MASKT, "-> PatchEventHandlerManager" + TRACE_METHOD);
        if (thePatchEventHandlerManager == null) {
            thePatchEventHandlerManager = new PatchEventHandlerManager();
        }
        Trace.trace(TRACE_MASKT, "<- PatchEventHandlerManager" + TRACE_METHOD);
        return thePatchEventHandlerManager;
    }

    private PatchEventHandlerManager() {
        String TRACE_METHOD = ".ctor()";
        Trace.trace(TRACE_MASKT, "<> PatchEventHandlerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PatchEventHandler listener) {
        String TRACE_METHOD = ".addListener()";
        Trace.trace(TRACE_MASKT, "-> PatchEventHandlerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            } else {
                Trace.trace(TRACE_MASKF, "   PatchEventHandlerManager" + TRACE_METHOD + " - listener [" + listener + "] was already registered");
            }
        }
        Trace.trace(TRACE_MASKT, "<- PatchEventHandlerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PatchEventHandler listener) {
        String TRACE_METHOD = ".removeListener()";
        Trace.trace(TRACE_MASKT, "-> PatchEventHandlerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.listeners.remove(listener)) {
                Trace.trace(TRACE_MASKF, "   PatchEventHandlerManager" + TRACE_METHOD + " - listener [" + listener + "] was not registered");
            }
        }
        Trace.trace(TRACE_MASKT, "<- PatchEventHandlerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(PatchEvent event) {
        ArrayList listeners;
        String TRACE_METHOD = ".fireEvent()";
        Trace.trace(TRACE_MASKT, "-> PatchEventHandlerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            listeners = (ArrayList)this.listeners.clone();
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            PatchEventHandler l = (PatchEventHandler)iterator.next();
            Trace.trace(TRACE_MASKF, "   PatchEventHandlerManager" + TRACE_METHOD + " - PatchEvent listener is " + l);
            l.handlePatchEvent(event);
        }
        Trace.trace(TRACE_MASKT, "<- PatchEventHandlerManager" + TRACE_METHOD);
    }

    public void firePatchEvent(PatchEvent event) {
        String TRACE_METHOD = ".firePatchEvent()";
        Trace.trace(TRACE_MASKT, "-> PatchEventHandlerManager" + TRACE_METHOD);
        this.fireEvent(event);
        Trace.trace(TRACE_MASKT, "<- PatchEventHandlerManager" + TRACE_METHOD);
    }
}

